<?php

/***************************************************************************
                  AutoIndex PHP Script, by Justin Hagstrom
                             -------------------

   filename             : config.php
   version              : 1.5.4
   date                 : August 11, 2005

   copyright            : Copyright (C) 2002-2005 Justin Hagstrom
   license              : GNU General Public License (GPL)

   website & forum      : http://autoindex.sourceforge.net
   e-mail               : JustinHagstrom [at] yahoo [dot] com


   AutoIndex PHP Script is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   AutoIndex PHP Script is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 ***************************************************************************/

if (!defined('CONFIG') || CONFIG !== true)
//make sure this file is being included from index.php
{
	die('<p>This file cannot be accessed directly.</p>');
}
if (!isset($stored_config, $config_generator))
//make sure variables in index.php are set
{
	die('<p>Error: Filenames not defined. Check index.php to make sure $stored_config and $config_generator are set.</p>');
}

if (count($_POST) == 38)
{
	$final_output = "<?php\n\n/*\n$stored_config generated by $config_generator\n"
		."Part of AutoIndex PHP Script\nhttp://autoindex.sourceforge.net\n*/\n\n\n";
	foreach ($_POST as $key => $current)
	{
		$current = str_replace('\'', '\\\'', str_replace('\\', '/', trim($current)));
		switch ($key)
		{
			case 'base_dir':
				if ($current == '')
				{
					die('<p>Error: Make sure $base_dir has been assigned a value.</p>');
				}
				if (!preg_match('#/$#', $current))
				//make sure there is a slash at the end of base_dir
				{
					$current .= '/';
				}
				if (!@is_dir($current))
				{
					die('<p>Error: $base_dir is not a valid directory.</p>');
				}
				$final_output .= "\n/*  Required settings:  */\n\n\$$key = '$current';\n";
				break;
			case 'icon_path':
				while (preg_match('#/$#', $current))
				//make sure there is not a slash at the end
				{
					$current = substr($current, 0, -1);
				}
			case 'stylesheet':
			case 'user_list':
			case 'log_file':
			case 'download_count':
			case 'links_file':
			case 'description_file':
			case 'index':
			case 'header':
			case 'footer':
			case 'path_to_language_files':
			case 'lang':
			case 'banned_list':
				//strings
				$final_output .= "\$$key = '$current';\n";
				break;
			case 'use_login_system':
				$final_output .= "\n\n/*  Optional settings:  */\n\n";
			case 'allow_uploads':
			case 'must_login_to_download':
			case 'allow_file_overwrites':
			case 'sub_folder_access':
			case 'force_download':
			case 'anti_leech':
			case 'enable_searching':
			case 'show_dir_size':
			case 'folder_expansion':
			case 'show_folder_count':
			case 'header_per_folder':
			case 'footer_per_folder':
			case 'show_type_column':
			case 'show_size_column':
			case 'show_date_column':
			case 'select_language':
				//booleans
				if ($current != 'true' && $current != 'false')
				{
					die('<p><strong>$'.htmlentities($key).'</strong> must be set to "true" or "false".</p>');
				}
				$final_output .= "\$$key = $current;\n";
				break;
			case 'thumbnail_height':
			case 'bandwidth_limit':
			case 'days_new':
			case 'md5_show':
				//numbers
				$current = (string)((float)$current);
				$final_output .= "\$$key = $current;\n";
				break;
			case 'dont_log_these_ips':
			case 'hidden_files':
			case 'show_only_these_files':
				//arrays
				if ($current == '')
				{
					$temp = 'array();';
				}
				else
				{
					$temp = 'array(';
					foreach (explode(',', $current) as $a)
					{
						$a = trim($a);
						if ($a != '')
						{
							$temp .= "\n\t\"$a\",";
						}
					}
					$temp = substr($temp, 0, -1) . ');';
				}
				$final_output .= "\$$key = $temp\n";
				break;
			default:
				die('<p><strong>$'.htmlentities($key).'</strong> is not a valid configuration setting.</p>');
		}
	}
	$final_output .= "\n?>";
	
	$_POST['base_dir'] = str_replace('\\', '/', trim($_POST['base_dir']));
	if ((preg_match('#^(/|[a-z]\:)#i', $_POST['base_dir']) || $_POST['bandwidth_limit'] != '0') && $_POST['force_download'] == 'false')
	{
		die('<p>Error: It seems you\'re using an absolute path for the <strong>base_dir</strong>, or <strong>bandwidth_limit</strong> is being used.
		<br />This requires that you have <strong>force_download</strong> turned on.</p>
		<p>You must set <strong>force_download</strong> to "true" so files can be downloaded.
		Otherwise, use a relative path instead of an absolute path or turn off <strong>bandwidth_limit</strong>.</p>');
	}
	if ($_POST['use_login_system'] == 'true' && !@is_file(trim($_POST['user_list'])))
	{
		die('<p>Error: Could not open the $user_list file.
		<br />Set $user_list to the correct file, or turn off the login system.</p>');
	}
	if ($_POST['icon_path'] == '' && $_POST['folder_expansion'] == 'true')
	{
		die('<p>Error: You must use icons for the folder_expansion feature to work.
		<br />Set icon_path to the path where the icons can be found.</p>');
	}

	if (@is_file($stored_config))
	//if the file already exists, back it up
	{
		$temp_name = $stored_config.'.bak';
		for ($i=1; @file_exists($temp_name); $i++)
		{
			$temp_name = $stored_config.'.bak'.(string)$i;
		}
		@copy($stored_config, $temp_name);
	}

	if ($h = @fopen($stored_config, 'wb'))
	//the file was opened successfully, so write to it
	{
		fwrite($h, $final_output);
		fclose($h);
		die('<h3>Write successful!<br />AutoIndex configuration is finished.</h3><h3><a href="'
			.$_SERVER['PHP_SELF'].'">Continue.</a></h3>');
	}
	else
	//the file could not be written to, so now it must be downloaded through the browser
	{
		header("Content-Type: text/plain; name=\"$stored_config\"");
		header("Content-Disposition: attachment; filename=\"$stored_config\"");
		die($final_output);
	}
}

//begin display of main configuration page
echo '<?xml version="1.0" encoding="iso-8859-1"?>';
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en">
<head>
	<link href="stylesheet.css" rel="stylesheet" title="AutoIndex Default" type="text/css" />
	<title>AutoIndex Configuration Generator</title>
</head>
<body class='autoindex_body'>
<form method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>?config=true">

<h3 style="text-align: center;">
	<a class="black_link" href="http://autoindex.sourceforge.net/">AutoIndex PHP Script</a>
	<br />Configuration
</h3>
<p>
	<strong>The default options are currently selected, so just press the configure button at the bottom to use them.</strong>
	<br /><span class="small">If you want to change them, though, it is important that you read the readme.html file, since it explains what each setting does.</span>
</p>

<hr class="default_hr" />

<p>
	<strong>Required Settings</strong>:
</p>

<table width="650" cellpadding="8"><tr class="paragraph"><td class="default_td">
base_dir = <input type="text" name="base_dir" value="./" />
<br />icon_path = <input type="text" name="icon_path" value="index_icons/winxp" />
<br />stylesheet = <input type="text" name="stylesheet" value="stylesheet.css" />
</td></tr></table>

<hr class="default_hr" />

<p>
	<strong>Optional Settings</strong>:
</p>

<table width="650" cellpadding="8"><tr class="paragraph"><td class="default_td">
use_login_system = <select name="use_login_system"><option selected="selected" value="false">false</option><option value="true">true</option></select>
<br />allow_uploads = <select name="allow_uploads"><option selected="selected" value="false">false</option><option value="true">true</option></select>
<br />must_login_to_download = <select name="must_login_to_download"><option selected="selected" value="false">false</option><option value="true">true</option></select>
<br />user_list = <input type="text" name="user_list" value=".htpasswd.autoindex" />
<br />allow_file_overwrites = <select name="allow_file_overwrites"><option selected="selected" value="false">false</option><option value="true">true</option></select>
</td></tr></table>

<p />
<table width="650" cellpadding="8"><tr class="paragraph"><td class="default_td">
log_file = <input type="text" name="log_file" />
<br />dont_log_these_ips = <input type="text" size="30" name="dont_log_these_ips" value="127.0.0.*" /> <span class="small">(Separate multiple items with commas.)</span>
<br />banned_list = <input type="text" name="banned_list" />
<br />download_count = <input type="text" name="download_count" />
<br />links_file = <input type="text" name="links_file" />
<br />description_file = <input type="text" name="description_file" />
</td></tr></table>

<p />
<table width="650" cellpadding="8"><tr class="paragraph"><td class="default_td">
sub_folder_access = <select name="sub_folder_access"><option selected="selected" value="true">true</option><option value="false">false</option></select>
<br />index = <input type="text" name="index" />
<br />hidden_files = <input type="text" name="hidden_files" size="80" value="$log_file, $links_file, $description_file, $banned_list, $stylesheet, $download_count, index_icons, languages, *.php, .ht*" />
<br /><span class="small">(Separate multiple items with commas.)</span>
<br />show_only_these_files = <input type="text" size="30" name="show_only_these_files" /> <span class="small">(Separate multiple items with commas.)</span>
</td></tr></table>

<p />
<table width="650" cellpadding="8"><tr class="paragraph"><td class="default_td">
force_download = <select name="force_download"><option selected="selected" value="false">false</option><option value="true">true</option></select>
<br />bandwidth_limit = <input type="text" name="bandwidth_limit" size="3" value="0" /> KB/s
<br />anti_leech = <select name="anti_leech"><option selected="selected" value="false">false</option><option value="true">true</option></select>
</td></tr></table>

<p />
<table width="650" cellpadding="8"><tr class="paragraph"><td class="default_td">
enable_searching = <select name="enable_searching"><option selected="selected" value="true">true</option><option value="false">false</option></select>
</td></tr></table>

<p />
<table width="650" cellpadding="8"><tr class="paragraph"><td class="default_td">
show_dir_size = <select name="show_dir_size"><option selected="selected" value="true">true</option><option value="false">false</option></select>
<br />folder_expansion = <select name="folder_expansion"><option selected="selected" value="false">false</option><option value="true">true</option></select>
<br />show_folder_count = <select name="show_folder_count"><option selected="selected" value="false">false</option><option value="true">true</option></select>
<br />days_new = <input type="text" name="days_new" size="3" value="0" /> days
<br />md5_show = <input type="text" name="md5_show" size="3" value="0" /> max size (MB)
<br />thumbnail_height = <input type="text" name="thumbnail_height" size="6" value="0" /> <span class="small">(in pixels, 0 to disable. GDlib 2.0.1 or higher is required.)</span>
</td></tr></table>

<p />
<table width="650" cellpadding="8"><tr class="paragraph"><td class="default_td">
header = <input type="text" name="header" />
<br />footer = <input type="text" name="footer" />
<br />header_per_folder = <select name="header_per_folder"><option selected="selected" value="false">false</option><option value="true">true</option></select>
<br />footer_per_folder = <select name="footer_per_folder"><option selected="selected" value="false">false</option><option value="true">true</option></select>
</td></tr></table>

<p />
<table width="650" cellpadding="8"><tr class="paragraph"><td class="default_td">
show_type_column = <select name="show_type_column"><option selected="selected" value="false">false</option><option value="true">true</option></select>
<br />show_size_column = <select name="show_size_column"><option selected="selected" value="true">true</option><option value="false">false</option></select>
<br />show_date_column = <select name="show_date_column"><option selected="selected" value="true">true</option><option value="false">false</option></select>
</td></tr></table>

<hr class="default_hr" />

<p>
	<strong>Language Settings</strong>:
</p>

<p />
<table width="650" cellpadding="8"><tr class="paragraph"><td class="default_td">
path_to_language_files = <input type="text" name="path_to_language_files" value="./languages/" />
<br />lang = <select name="lang">
<?php

function get_all_langs($path)
{
	if (($hndl = @opendir($path)) === false)
	{
		return array('en.php');
	}
	$list = array();
	while (($file = readdir($hndl)) !== false)
	{
		if (@is_file($path.$file) && preg_match('/^[a-z]{2}(_[a-z]{2})?\.php$/i', $file))
		{
			$list[] = $file;
		}
	}
	closedir($hndl);
	return $list;
}

$l = get_all_langs('./languages/');
sort($l);
for ($i=0; $i<count($l); $i++)
{
	$f = substr($l[$i], 0, -4);
	$sel = (($f == 'en') ? ' selected="selected"' : '');
	echo "\t<option$sel>$f</option>\n";
}

?>
</select>
<br />select_language = <select name="select_language"><option selected="selected" value="false">false</option><option value="true">true</option></select>
</td></tr></table>
<hr class="default_hr" />
<p>
	<input type="submit" value="Configure" />
</p>
<p>
	When you press <em>Configure</em>, the script will attempt to write the config data to the file.
	<br />If it cannot (for example if it does not have write permission in the directory) the config file will be downloaded, and you will have to upload it to your server.
	<br />(It should be named <em><?php echo $stored_config; ?></em> and put in the same folder as <em>index.php</em>)
</p>

</form>

<!--

Powered by AutoIndex PHP Script (version <?php echo VERSION; ?>)
Copyright (C) 2002-2005 Justin Hagstrom
http://autoindex.sourceforge.net

Page generated in <?php echo round((get_microtime() - $start_time) * 1000, 1); ?> milliseconds.

-->

</body></html>